;**********************************************
; Test write and read EEPROM 24LC128
; Hardware  : CP-PIC V3.0 & V4.0
; OSC	    : 10 MHz [HS mode]
; Assembler : mpasm.exe
; Programmer: Watcharin Kaorop
; Company   : ETT  CO.,LTD.
; Date      : 01/8/2002
;**********************************************

     LIST P=16f877
     include <p16f877.inc>

#define   SDA     PORTC,4  
#define   SCL     PORTC,3

DT1       EQU       0x20
DT2       EQU       0x21
RD_BUF    EQU       0x22
WR_BUF    EQU       0x23
COUNT     EQU       0x24
COUNT10   EQU	    0x25
DAT       EQU       0x26
B1        EQU       0x27
B2        EQU       0x28
       

;*********************************************
          ORG       0x0000
          
	  BSF	    STATUS,RP0     ; select bank 1
          BCF       TRISC,4
          BCF       TRISC,3
          MOVLW     0x40           ; BAUD rate 9600
          MOVWF     SPBRG
          CLRF      TXSTA          ; 8 bits data ,no,1 stop
          BSF       TXSTA,TXEN     ; Transmit enable
	  BSF	    TXSTA,BRGH     ; hi speed

	  BCF	    STATUS,RP0     ; select bank 0
          CLRF      RCSTA
          BSF       RCSTA,SPEN     ; Asynchronous serial port enable
          BSF       RCSTA,CREN     ; continuous receive
	  
          MOVLW	    .10	           ; counter for data to write
	  MOVWF     COUNT10
	               
          CALL	    START	  
          MOVLW     0xA8           ; control byte
          CALL      WR_I2C          
	  MOVLW     0              ;  Start address = 00
          CALL	    WR_I2C   
	  MOVLW	    0
	  CALL      WR_I2C 
	  	 	    
          CLRF      DAT	    
WR_EEP	  MOVF	    DAT,W          ; write loop  
          CALL	    WR_I2C
	  INCF	    DAT,f
	  DECFSZ    COUNT10
	  GOTO	    WR_EEP     
          	  
	  CALL      STOP        
	  CALL      ACK_P
          CALL      SDEL           ; delay more than 10 mS

st        MOVLW     0x0C           ; Clear display
          CALL      SEND
          MOVLW     "D"
          CALL      SEND
          MOVLW     "A"
          CALL      SEND
          MOVLW     "T"
          CALL      SEND
          MOVLW     "A"
          CALL      SEND
          MOVLW     " "
          CALL      SEND
          MOVLW     "E"
          CALL      SEND        
	  MOVLW     "E"
          CALL      SEND
          MOVLW     "P"
          CALL      SEND
          MOVLW     "R"
          CALL      SEND
          MOVLW     "O"
          CALL      SEND
          MOVLW     "M"
          CALL      SEND
         
          MOVLW     0xA             ; new line
          CALL      SEND
          MOVLW     0xD
          CALL      SEND
 	  MOVLW     " "
	  CALL      SEND

;*********** READ DATA FORM EEPROM *************
	  
	  CLRF	    DAT	           ; start Address data = 00
  	  MOVLW	    .10		   ; counter for loop = 10
	  MOVWF     COUNT10
RD_EEP    CALL	    START
          MOVLW     0xA8           ; control byte
          CALL	    WR_I2C
	  MOVLW	    0x0
	  CALL      WR_I2C	  
	  MOVF	    DAT,W	   ; read data address of DAT
	  CALL	    WR_I2C
	  CALL	    START
	  MOVLW	    0xA9	   ; control byte read
	  CALL	    WR_I2C
		  	    
NN	  CALL	    RD_I2C
	  MOVF      RD_BUF,W	   ; save data to w
	  CALL      ADJT           ; display data
	  MOVLW     " "
          CALL      SEND
	 
	  DECFSZ    COUNT10,F
	  GOTO      NO_0           ; count10 != '0'
	  GOTO      RD_END	   ; count10  = '0'
NO_0	  INCF	    DAT,F	   
	  GOTO      RD_EEP

RD_END	  CALL	    N_ACK	   
	  CALL	    STOP
	  GOTO	    $



;**********************************************************
; Convert time 1 byte to ASCII 2 bytes and send to display
; Input  : W
; Output : -
;**********************************************************
ADJT      MOVWF     B1             ; B1 = HHHH LLLL
          SWAPF     B1,W           ; W  = LLLL HHHH
          ANDLW     0x0F           ; Mask upper four bits 0000 HHHH
          ADDLW     0x30           ; convert to ASCII
          CALL      SEND           ; Send first digit
          MOVF      B1,W
          ANDLW     0x0F           ; w  = 0000 LLLL
          ADDLW     0x30           ; convert to ASCII
          CALL      SEND
          RETURN

;********************************************************
; Send data to RS-232 2400 Buad,8 bits data, No parity, 1 stop
; Input  : W
; Output : Computer screen
;********************************************************
SEND      MOVWF     TXREG          ; Send recent data to TX 
WAIT1     MOVLW     TXSTA
	  MOVWF	    FSR
          BTFSS     INDF,1         ; check TRMT bit in TXSTA register
	  GOTO      WAIT1          ; TXREG full  or TRMT = 0
          RETURN


;****************** WRITE DATA TO I2C BUS ************************

WR_I2C		MOVWF	WR_BUF	    ; Data Write to buffer
		MOVLW	.8
		MOVWF	COUNT	    ; Counter loop = 8
		CALL	SCL_LOW	    ; SCL LOW
		CALL    DELAY
WR_LOOP	        RLF	WR_BUF,F    ; Rotate DATA to Carry FLAG
		BC	SEND_1	    ; Banch IF Carry flag = 1
SEND_0		CALL    SDA_LOW
		CALL	PULSE
		GOTO	CHECK	    ; Check Counter
SEND_1		CALL	SDA_HIGH
		CALL	PULSE
CHECK		DECFSZ	COUNT,F
		GOTO	WR_LOOP
		CALL	SDA_HIGH
		CALL	RD_ACK	    ; Read ack
		RETURN 


;************************************
; Read data Form I2C Bus
;************************************
RD_I2C		MOVLW	.8	    ; Counter loop = 8
		MOVWF	COUNT
		CLRF    RD_BUF	    ; clear read buffer
		CALL	SCL_LOW
		CALL	SDA_HIGH
RD_LOOP	        CALL	SCL_HIGH
		BTFSC	SDA
		GOTO	RD_1	    ; read data = 1
RD_0		CLRC
		GOTO	ROTATE
RD_1		SETC		    ; set carry flag 
ROTATE		RLF	RD_BUF,F    ; Get data to buffer
		CALL	SCL_LOW
		DECFSZ	COUNT,F	    
		GOTO	RD_LOOP
		RETURN

;********  READ ACK **************
RD_ACK  	CALL	SDA_HIGH     ; SDA Hi
		CALL	SCL_LOW	     ; SCL Lo
		CALL	SCL_HIGH     ; SCL Hi
		BTFSC	SDA	     ; Check SDA Skip when = 0
		GOTO	STOP	     ; No Ack
		BTFSS	SCL	     ; Check SCL Skip when = 1
		GOTO	$-1
	        CALL	SCL_LOW      ; SCL Lo
		CALL    DELAY
		RETURN

;******** SEND ACK ************
S_ACK	        CALL	SCL_LOW
		CALL	SDA_LOW
		CALL	SCL_HIGH
		CALL	SCL_LOW
		CALL	SDA_HIGH
		RETURN

;********  SEND NACK *********
N_ACK	        CALL	SCL_LOW
		CALL	SDA_HIGH
		CALL	SCL_HIGH
		CALL	SCL_LOW
		RETURN

;*********** ACK POLLING **********
ACK_P   	CALL	SCL_LOW
		CALL	START	     ; Start 
		MOVLW	0XA8	     ; control address A8H
		CALL	WRITE	     ; write to eeprom
        	CALL	SDA_HIGH     
		CALL	SCL_LOW
		CALL	SCL_HIGH
		BTFSC	SDA	     ; Check SDA Skip when 0
		GOTO	ACK_P
		CALL	SCL_LOW
		RETURN

WRITE		MOVWF	WR_BUF	     ; data to buffer
		MOVLW	.8	     ; counter loop = 8
		MOVWF	COUNT
		CALL	SCL_LOW
		CALL    DELAY
RO_TATE	        RLF	WR_BUF,F     ; Get data
		BC	SEND1
SEND0		CALL    SDA_LOW
		CALL	PULSE
		GOTO	CHK
SEND1		CALL	SDA_HIGH
		CALL	PULSE
CHK		DECFSZ	COUNT,F
		GOTO	RO_TATE
		CALL	SDA_HIGH
		RETURN 

;******************************
; Start bit
;******************************
START		CALL	SDA_HIGH
		CALL	SCL_HIGH
		BTFSS	SCL
		GOTO	$-1
		BTFSS	SDA
		GOTO	$-1
		CALL	SDA_LOW
		CALL	SCL_LOW
		RETURN

;********  STOP *************
STOP		CALL	SCL_LOW
		CALL	SDA_LOW
		CALL	SCL_HIGH
		CALL	SDA_HIGH
		CALL	DELAY
		RETURN

;******** SCL PULSE *************** 
PULSE    	CALL	SCL_LOW
	        CALL    DELAY
		CALL	SCL_HIGH
	        CALL    DELAY
		CALL	SCL_LOW
		RETURN

;********** SCL HIGH ********************
SCL_HIGH
        	BANKSEL TRISC
		BSF	TRISC,3
		BANKSEL	PORTC
		RETURN

;******** SCL LOW **********************
SCL_LOW
		BANKSEL	TRISC
		BCF	TRISC,3
		BANKSEL	PORTC
		BCF	SCL
		RETURN

;******** SDA HIGH ********************
SDA_HIGH	
		BANKSEL	TRISC
		BSF	TRISC,4
		BANKSEL	PORTC
		RETURN

;********  SDA  LOW *****************
SDA_LOW		
		BANKSEL	TRISC
		BCF	TRISC,4
		BANKSEL	PORTC
		BCF	SDA
		RETURN
;******************************
; DELAY TIME
;******************************
DELAY     MOVLW	    .5
	  MOVWF	    DT1
	  DECFSZ    DT1,F
	  GOTO	    $-1
	  RETURN

SDEL      MOVLW     0x00
          MOVWF     DT1
SD2       MOVLW     0x00
          MOVWF     DT2
SD1       DECFSZ    DT2
          GOTO      SD1
          DECFSZ    DT1
          GOTO      SD2
          RETURN
	
	END
